<?php

// create LM object, pass in PDO connection
$lm = new lazy_mofo($dbh); 

// table name for updates, inserts and deletes
$lm->table = 'u_biometrics';

// identity / primary key for table
$lm->identity_name = 'id';

$lm->grid_limit = 10;
//$lm->grid_text_input_size = 40;
//$lm->grid_text_no_records_found = '';
// Rename Column
$lm->rename['id'] = 'Trans. ID';
//$lm->rename['cashier'] = 'Cashier';
//$lm->rename['hrmlab'] = 'HRM Lab';
//$lm->rename['comlab'] = 'COMP Lab';
//$lm->rename['guidance'] = 'Guidance';
//$lm->rename['proware'] = 'Proware';
//$lm->rename['osa'] = 'OSA';
//$lm->rename['e2e'] = 'E2E';

//$lm->form_text_title_edit = 'Student Clearance';
//$lm->grid_edit_link = str_replace('[edit]', '[Clearance]', $lm->grid_edit_link);

$lm->grid_output_control['imageIn'] = array('type' => 'image');
$lm->grid_output_control['imageOut'] = array('type' => 'image');

// new in version >= 2015-02-27 all searches have to be done manually
$lm->grid_show_search_box = true;

$search_ = $lm->clean_out(@$_REQUEST['search_']);

// define sql

	$lm->grid_sql = "
	SELECT
	a.id
	, a.employeeNo 
	, concat(b.lastName,', ', b.firstName) as employeeName
	, a.biometricsDate
	, a.biometricsTimeIn
	, a.imageIn
	, a.biometricsDateOut
	, a.biometricsTimeOut
	, a.imageOut
	, a.dateUpdated
	from u_biometrics a
	left join e_basicinfo b
	on a.employeeNo  = b.employeeNo
	where biometricsDeviceLog='QR-DTR' and ( coalesce(a.employeeNo, '') like :_search 
	or  coalesce(b.lastName, '') like :_search 
	or    coalesce(a.biometricsDate, '') like :_search )
	order by a.dateUpdated desc
	";
	$lm->grid_sql_param[':_search'] = '%' . trim(@$_REQUEST['_search']) . '%';


// optional, define what is displayed on edit form. identity id must be passed in also. 

	$lm->form_sql = "
	SELECT
	id
	, employeeNo
	, biometricsDate
	, biometricsTimeIn
	, biometricsTimeOut
	, dateUpdated
	from  u_biometrics 
	where id = :id
	";

	// bind parameter for form query
	$lm->form_sql_param[':id'] = @$_REQUEST['id'];
	//$lm->form_sql_param[":$lm->identity_name"] = @$_REQUEST[$lm->identity_name];

$lm->grid_add_link = '';
$lm->grid_export_link = "<a href='[script_name]_export=1&amp;[qs]' class='button is-success is-small' title='Download CSV'>Export as CSV</a>";

$lm->grid_edit_link = false;
$lm->grid_delete_link = false;

$lm->return_to_edit_after_insert = false;
$lm->return_to_edit_after_update = false;

// use the lm controller
$lm->run();

?>
